package server;

import java.util.*;
import common.*;

/**
 * Search model: Performs searches for records matching the last character of
 * each database record.
 */
public class Model implements IModel {

	private final IDatabase database;

	public Model(IDatabase database) {
		this.database = database;
	}

	public List<String> performSearch(String searchValue) {
		ArrayList<String> result = new ArrayList<String>();
		String[] records = database.getData();
		for (int dbIdx = 0; dbIdx < records.length; ++dbIdx) {
			String record = records[dbIdx];
			if (record.endsWith(searchValue)) {
				result.add(record);
			}
		}
		return result;
	}
}
